clear
close all
clc
%% TURBINE BUILDING
prompt = 'write turbine name: ';

name = input(prompt,'s');
directory = pwd;
dhalf = strsplit(directory,'sim');% prendo la directory corretta

if strcmp(name,'TUDelft-6MW') == 1
    load(strcat('blades',name,'.mat'));
    dnew = strcat(dhalf(1),'simulazioni vento variabile\STL\bladetud6000.stl');
    dnew = string(dnew);
    turbcomp.blades.CAD = dnew;
    turbcomp.blades.mass = 43000; % kg (SUPPOSED)
    turbcomp.blades.radius = geometry(:,1);
    turbcomp.blades.inclination = geometry(:,3)*180/pi;
    turbcomp.blades.length = geometry(:,2)+5;
    turbcomp.blades.size = geometry(:,4);
    turbcomp.blades.chord = geometry(:,5);
    turbcomp.blades.inc = -5; % deg
    turbcomp.blades.zoffset = 28; % m
    turbcomp.blades.roffset = 63.5; % m: average radius of the turbine
    turbcomp.blades.zblade = -20; % m
    turbcomp.blades.thblade = 30; % deg: rotation angle to fit reference systems of blades and of nacelle
    dnew = strcat(dhalf(1),'simulazioni vento variabile\STL\toptud6000.stl');
    dnew = string(dnew);
    turbcomp.nacelle.CAD = dnew;
    turbcomp.nacelle.mass = 240000; % kg (SUPPOSED)
    turbcomp.nacelle.ztop = 0;
    turbcomp.shaft.mass = 160000; % kg (SUPPOSED)
    turbcomp.shaft.zshaft = 35; % m
    turbcomp.shaft.lshaft = 70;
    turbcomp.shaft.rshaft = 0.325; % from dimensioning with SF = 3
    dnew = strcat(dhalf(1),'simulazioni vento variabile\STL\towertud6000.stl');
    dnew = string(dnew);
    turbcomp.tower.CAD = dnew;
    turbcomp.tower.mass = 85000; % kg (SUPPOSED)
    turbcomp.tower.ztower = 33.5; % m
    load(strcat('Data',name,'.mat'));
    turbcomp.nominal.Vnom = Nominal.Vnom;
    turbcomp.ctrl.c1 = -197548;
    turbcomp.ctrl.c2 = -279564;
    turbcomp.ctrl.JJ = 2e8;
    turbcomp.ctrl.dTdt = 1455000;
    
    Fn = load(strcat('Fn',name,'.mat'));
    Ft = load(strcat('Ft',name,'.mat'));
    Mz = load(strcat('Mz',name,'.mat'));
    Tavg = load(strcat('Tavg',name,'.mat'));
    aerodata.Fn=Fn;
    aerodata.Ft=Ft;
    aerodata.Mz=Mz;
    aerodata.Tavg=Tavg;
    
    save(strcat(name,'-turbine.mat'),'-struct','turbcomp');
    save(strcat(name,'-AeroData.mat'),'-struct','aerodata');
    
elseif strcmp(name,'Uppsala-200kW') == 1
    
    load(strcat('blades',name,'.mat'));
    turbcomp.blades.radius = geometry(:,1);
    turbcomp.blades.inclination = geometry(:,3)*180/pi;
    turbcomp.blades.length = geometry(:,2);
    turbcomp.blades.size = geometry(:,4);
    turbcomp.blades.chord = geometry(:,5);
    dnew = strcat(dhalf(1),'simulazioni vento variabile\STL\bladeu200.stl');
    dnew = string(dnew);
    turbcomp.blades.CAD = dnew;
    turbcomp.blades.mass = 1500; % kg (SUPPOSED)
    turbcomp.blades.inc = 0; % deg
    turbcomp.blades.zoffset = 0; % m
    turbcomp.blades.roffset = 13; % m
    turbcomp.blades.zblade = 0; % m
    turbcomp.blades.thblade = -60; % deg
    turbcomp.nacelle.mass = 6000; % kg (SUPPOSED)
    dnew = strcat(dhalf(1),'simulazioni vento variabile\STL\topu200.stl');
    dnew = string(dnew);
    turbcomp.nacelle.CAD = dnew;
    turbcomp.nacelle.ztop = 2.5;
    turbcomp.shaft.mass = 10000; % kg (SUPPOSED)
    turbcomp.shaft.zshaft = 21.2; % m
    turbcomp.shaft.lshaft = 42;
    turbcomp.shaft.rshaft = 0.0625; % from dimensioning with SF = 3
    dnew = strcat(dhalf(1),'simulazioni vento variabile\STL\toweru200.stl');
    dnew = string(dnew);
    turbcomp.tower.CAD = dnew;
    turbcomp.tower.mass = 8600; % kg (SUPPOSED)
    turbcomp.tower.ztower = 16.8; % m
    load(strcat('Data',name,'.mat'));
    turbcomp.nominal.Vnom = Nominal.Vnom;
    turbcomp.ctrl.c1 = -5901;
    turbcomp.ctrl.c2 = -18998;
    turbcomp.ctrl.JJ = 300000;
    turbcomp.ctrl.dTdt = 48500;
    
    Fn = load(strcat('Fn',name,'.mat'));
    Ft = load(strcat('Ft',name,'.mat'));
    Mz = load(strcat('Mz',name,'.mat'));
    Tavg = load(strcat('Tavg',name,'.mat'));
    aerodata.Fn=Fn;
    aerodata.Ft=Ft;
    aerodata.Mz=Mz;
    aerodata.Tavg=Tavg;
    
    save(strcat(name,'-turbine.mat'),'-struct','turbcomp');
    save(strcat(name,'-AeroData.mat'),'-struct','aerodata');
else
    disp('put correct name for turbine');
end